/*********************************************
******	ADC Vref 2V ʹע	******
**********************************************
ADC(internal Vref 2V)ʹ÷ע
ADCжģʽģʽ(single mode)ظģʽ(repeat mode)

1. ADCʼ
	1-1. ȡADC ڲVref_2V֮ʵֵ(λΪmV), 㴦(VrefReal2048)ʽ£
			(VrefReal2048) = (Vref_2V֮ʵֵ)*2048/2000;
		 Ϊ2000(2Ĵη),Ứ϶ʱ㣬ʽ,
		 ֻ֮2048(2Ĵη),֮ADCУ׼ʱ(ADCת֮˵)
	1-2. ADCת(˵), ȡADC ƫ(ADC_offset)
2. ADCת
	2-1. n(ADC_count)ת, ȡnADC֮ܺ(ADC_sum), (nֵΪ32),
	2-3. (ADC_result)=(ADC_sum)-(ADCƫ), (ADC_result)С(ADCƫ), ȡ(ADC_result)Ϊ0
	2-2. ADCȷΪ:
			(ADC_result) * (VrefReal2048) / 2048 / (ADCת=n)
	2-4. 뽫бתΪunsigned long ̬Լճ̵

Cautions:
	ȡADCʱȶȡλ(ADCDRL)ٶȡλ(ADCDRH)
***********************************************/
#ifndef __ADC_H_
#define __ADC_H_


//-- header guards --//
#ifndef	uchar
#define uchar unsigned char
#endif
#ifndef	uint
#define uint  unsigned int
#endif
#ifndef	ulong
#define ulong unsigned long
#endif


/******************
 * 1st Argument
 * ****************/
#define		ADC_Single		0x1	// single mode
#define		ADC_Repeat		0x3	// repeat mode
/******************
 * 2nd Argument
 * ****************/
#define		AIN_DIS			0x0	// analog input disable
#define		AIN_EN			0x1	// analog input enable
/******************
 * 3rd Argument
 * ****************/
#define		AIN0			0x0	// set analog input channel to AIN0
#define		AIN1			0x1	// set analog input channel to AIN1
#define		AIN2			0x2	// set analog input channel to AIN2
#define		AIN3			0x3	// set analog input channel to AIN3
#define		AIN4			0x4	// set analog input channel to AIN4
#define		AIN5			0x5	// set analog input channel to AIN5
#define		AIN6			0x6	// set analog input channel to AIN6
#define		AIN7			0x7	// set analog input channel to AIN7
#define 	AIN8			0x8	// set analog input channel to AIN8
#define		VDD4_1			0x9	// set analog input channel to internal 1/4 VDD input
#define		AIN_GND      	0xc	// set analog input channel to internal ground
/******************
 * 4th Argument
 * ****************/
// fcgck=16M... Conv256CLK(16us) ~ Conv1024CLK( 64us)
// fcgck= 8M... Conv128CLK(16us) ~ Conv1024CLK(128us)
// fcgck= 4M... Conv64CLK (16us) ~ Conv512CLK (128us)
// fcgck= 2M... Conv32CLK (16us) ~ Conv256CLK (128us)
#define		Conv32CLK		0x0	// set conversion times to 32 fcgck
#define		Conv64CLK		0x1	// set conversion times to 64 fcgck
#define		Conv128CLK		0x2	// set conversion times to 128 fcgck
#define		Conv256CLK		0x3	// set conversion times to 256 fcgck
#define		Conv512CLK		0x4	// set conversion times to 512 fcgck
#define		Conv1024CLK		0x5	// set conversion times to 1024 fcgck
								// (*conversion times must be between 12.8 us to 128 us)
/******************
 * 5th Argument
 * ****************/
#define		Vref2			0x0	// set ADC reference voltage to internal 2V
#define		Vref3			0x1	// set ADC reference voltage to internal 3V
#define		Vref4			0x2	// set ADC reference voltage to internal 4V
#define		VDDVref			0x3	// set ADC reference voltage to internal VDD
#define		EXTVref			0x4	// set ADC reference voltage to external voltage (AIN3)
								// when AIN3 is used as the external voltage input, AIN3 cannot be used to analog input


//-- ȫֱ --//
extern uint  vref_l, vref_h;
extern uchar Flag;
extern ulong iReal_Vref2V, adc_value, adc_GND;
extern ulong VrefReal2048;


uint  GetVref(void);
ulong ADC_detect(uchar, uchar, uchar, uchar);
ulong ADC_ConvCode(uchar, uchar, uchar, uchar);
ulong ADC_ConvVolt(uchar, uchar, uchar, uchar);

#define	ad_test_times	1

#endif


















